
from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI

import Pyro4
import time
import sys

#from mupif.api.api import *
from mupif import bbox
from mupif import viewcontext
from mupif import field
from mupif import meshview
from mupif import timestep
from mupif import util
from mupif import agent
from mupif import transferoperator

from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors
#from mayavi.filters.transform_data import TransformData

graphics = 1

def main(argv=sys.argv):
    global mayavi

    sys.setrecursionlimit(1000)
    print "Initializing ....",
    t0=time.clock()
    api=[]
    remoteField=[]
    tstep=timestep.TimeStep(1.,1.)
    # get source data api's
    for rank in range(4):
        api.append(Pyro4.Proxy("PYRONAME:Mupif.agent.example10."+str(rank)))
        remoteField.append(Pyro4.core.Proxy(api[rank].giveFieldUri(1,tstep)))
    myrank = int(argv[len(argv)-1])
    #initialize mesh
    mymesh = util.readOfemMesh('jete4.np02.oofem.in.'+str(myrank))
    # create empty target field
    myfield = field.Field(mymesh, field.FieldID.FID_Temperature, field.FieldType.vertex_based, field.FieldValueType.scalar)
 
    # determine mymesh bbox
    mybbox=bbox.BBox(list(mymesh.giveVertex(0).coords), list(mymesh.giveVertex(0).coords))
    for v in mymesh.vertices():
        mybbox.merge(v.coords)
    print "Mymesh ", mybbox

    #obtain local field view of remote data (field1), with unlinked master field
    # to prevent its serialization
    init = True
    start = time.clock()
    for rank in range(4):
        if init:
            lfv = api[rank].giveBBoxFieldView(mybbox, 1, tstep, unlinkMaster=True)
            lfv.master=remoteField[rank]
            lfv.update()
            init=False
        else:
            #merge with remaining
            _lfv = api[rank].giveBBoxFieldView(mybbox, 1, tstep, unlinkMaster=True)
            _lfv.master=remoteField[rank] #set reference to remote master           
            _lfv.update() #update from remote master values
            lfv.merge(_lfv)
    print "Rank:", myrank, "Remote data miroring took ", (time.clock() - start), "[seconds]"

    start = time.clock()
    transferoperator.CellInterpolationTO().map(lfv, myfield)
    #print lfv.evaluate((23.699999999999999, 0.0, 33.299999999999997))
    elapsed = (time.clock() - start)
    print "Rank:", myrank, "Local Mapping took ", elapsed, "[seconds]"


    #src00 = util.mesh2VTKDataSource(mymesh)
    src00 = util.field2VTKDataSource(myfield)
    mayavi.add_source(src00)
    mayavi.add_module(Outline())
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)
    
    if 1:
        src1 = util.field2VTKDataSource(lfv)
        mayavi.add_source(src1)
        mayavi.add_module(Outline())
        m = Surface()
        m.actor.property.representation='w'
        mayavi.add_module(m)
        
    
if __name__ == '__main__':

    try:
        mayavi
        mayavi.new_scene()
        main(sys.argv)
        
    except NameError:
        mayavi = Engine()
        mayavi.new_scene()
        main(sys.argv)
        gui = GUI()
        gui.start_event_loop()
