#!/usr/bin/env python


#
# This example ilustrates interaction with remote agent (field query)
# and merging two fieldViews of remote data
#
#
#   To run this example:
# 1) start pyro name server (In terminal run: python -m Pyro4.naming)
# 2) run a series of 4 python test10.py instances like: "python test10.py rank", where rank is [0,1,2,3]
# 3) run a series of 2 jobs: "python test10b.py rank", where rank is [0,1] 
#

import Pyro4
import sys
import math

from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI
from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors

from mupif import field
from mupif import mesh
from mupif import timestep
from mupif import util
from mupif import api
from mupif import vertex
from mupif import cell
from mupif import transferoperator
from mupif import viewcontext
from mupif import agent
from mupif.api.api import *

daemon = Pyro4.Daemon()
ns     = Pyro4.locateNS()

def f(x,y,z):
    return z


def main(argv=sys.argv):

    myrank=int(argv[1])
    
    mymesh = util.readOfemMesh('jete4.np04.oofem.in.'+str(myrank))
    #initialize simple field 
    values=[]
    for v in mymesh.vertices():
        values.append((f(v.coords[0], v.coords[1], v.coords[2]),))
    myfield = field.Field(mymesh, field.FieldID.FID_Temperature, field.FieldValueType.scalar, field.FieldType.vertex_based, values)
    #print myfield.evaluate((23.0,0,10.0))
    if 1:
        src = util.field2VTKDataSource(myfield)
        mayavi.add_source(src)
        mayavi.add_module(Outline())
        m = Surface()
        m.actor.property.representation='w'
        mayavi.add_module(m)
    
    #create a simple agent 
    MyAgent = agent.Agent(daemon, ns, "agent.example10."+str(myrank))
    tstep=timestep.TimeStep(1.,1.)
    # register field_a under key "1"
    MyAgent.registerField(myfield, 1, tstep)
    daemon.requestLoop()

if __name__ == '__main__':

    try:
        mayavi
        mayavi.new_scene()
        main()
        
    except NameError:
        mayavi = Engine()
        mayavi.new_scene()
        main()
        gui = GUI()
        gui.start_event_loop()

        
