#!/usr/bin/env python


#
# This example ilustrates interaction with remote agent (field query)
# and merging two fieldViews of remote data
#
#
#   To run this example:
# 1) start pyro name server (In terminal run: python -m Pyro4.naming)
# 2) run a series of python test08a.py instances
# 3) run: python test08b.py
#

import Pyro4
import sys
import math

from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI
from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors

from mupif import field
from mupif import mesh
from mupif import timestep
from mupif import util
from mupif import api
from mupif import vertex
from mupif import cell
from mupif import transferoperator
from mupif import viewcontext
from mupif import agent
from mupif.api.api import *

daemon = Pyro4.Daemon()
ns     = Pyro4.locateNS()


subdomain_width=3.0  # should be integer multiple of subdomain_delta
subdomain_height=1.0 # should be integer multiple of subdomain_delta
subdomain_delta=0.05 # element size (squares assumed)
subdomain_nrows = 3
subdomain_ncols = 2



# do not change parameters bellow this line

subdomain_nelemInRow = int(subdomain_height/subdomain_delta)
subdomain_nelemInCol = int(subdomain_width/subdomain_delta)
nelem = subdomain_nelemInRow*subdomain_nelemInCol
nnode = (subdomain_nelemInRow+1)*(subdomain_nelemInCol+1)

total_vertex_rows = subdomain_nelemInRow*subdomain_nrows+1
total_vertex_cols = subdomain_nelemInCol*subdomain_ncols+1

total_cell_rows = subdomain_nelemInRow*subdomain_nrows
total_cell_cols = subdomain_nelemInCol*subdomain_ncols


def giveVertexLabel(globalRow, globalCol):
    return globalRow*total_vertex_cols+globalCol

def giveCellLabel(globalRow, globalCol):
    return globalRow*total_cell_cols+globalCol

srcs=[]
fields=[]
meshes=[]

def f(x,y):
    return math.sin(x*(3.0*3.14159265/3.))*math.sin(y*(3.0*3.14159265/2.))

def genMesh(subdomain_row_indx, subdomain_col_indx):

    print ".",
    startCellGlobalRow = subdomain_nelemInRow * subdomain_row_indx
    startCellGlobalCol = subdomain_nelemInCol * subdomain_col_indx
    startVertexGlobalRow = startCellGlobalRow
    startVertexGlobalCol = startCellGlobalCol
    
    mesh_a = mesh.UnstructuredMesh()
    # generate mesh_a and scalar vertex values
    vertices_a=[]
    values_a = []
    for i in range(subdomain_nelemInRow+1):
        for j in range (subdomain_nelemInCol+1):
            globalRow=startVertexGlobalRow+i
            globalCol=startVertexGlobalCol+j
            x=globalCol*subdomain_delta
            y=globalRow*subdomain_delta
            num= (i*(subdomain_nelemInCol+1))+j #local number
            label= giveVertexLabel(globalRow, globalCol) #global label
            vertices_a.append(vertex.Vertex(num, label, (x,y,0)))
            values_a.append((f(x,y),))
#--------
    cells_a = []
    for i in range(subdomain_nelemInRow):
        for j in range (subdomain_nelemInCol):
            globalRow=startCellGlobalRow+i
            globalCol=startCellGlobalCol+j
            num=i*subdomain_nelemInCol+j
            label=giveCellLabel(globalRow, globalCol)
            n1 = i*(subdomain_nelemInCol+1)+j
            n2 = (i+1)*(subdomain_nelemInCol+1)+j
            n3 = (i+1)*(subdomain_nelemInCol+1)+j+1
            n4 = i*(subdomain_nelemInCol+1)+j+1
            cells_a.append(cell.Quad_2d_lin(mesh_a, num, label, (n1, n2, n3, n4)))
                    

    mesh_a.setup(vertices_a, cells_a)
    field_a = field.Field(mesh_a, field.FieldID.FID_Temperature, field.FieldType.vertex_based, field.FieldValueType.scalar, values_a)
            
    if 1:
        field_a = field.Field(mesh_a, field.FieldID.FID_Temperature, field.FieldType.vertex_based, field.FieldValueType.scalar, values_a)
        src1 = util.field2VTKDataSource(field_a)
        fields.append(field_a)
        meshes.append(mesh_a)
        srcs.append(src1)
    if 1:
        mayavi.add_source(src1)
        mayavi.add_module(Outline())
        m = Surface()
        m.actor.property.representation='w'
        mayavi.add_module(m)

    return (field_a, src1)


def main(argv=sys.argv):
    
    #subdomain_row_indx = int(argv[1])
    #subdomain_col_indx = int(argv[2])

    (f1, s1) = genMesh(0,0)
    (f2, s2) = genMesh(1,0)

    if 1:
    #create a simple agent
        MyAgent = agent.Agent(daemon, ns, "example08.agent")
        tstep=timestep.TimeStep(1.,1.)
    # register field_a under key "1"
        MyAgent.registerField(f1, 1, tstep)
        MyAgent.registerField(f2, 2, tstep)


    #register agent
    #uri    = daemon.register(MyAgent)
    #ns.register("example.agent", uri)
        daemon.requestLoop()
    

if __name__ == '__main__':

    try:
        mayavi
        mayavi.new_scene()
        main()
        
    except NameError:
        mayavi = Engine()
        mayavi.new_scene()
        main()
        gui = GUI()
        gui.start_event_loop()

        
