#!/usr/bin/env python

#   To run this example:
# 1) start pyro name server (In terminal run: python -m Pyro4.naming)
# 2) run: python test06a.py
# 3) run: python test06b.py
#

import Pyro4

from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI

from mupif import field
from mupif import mesh
from mupif import timestep
from mupif import util
from mupif import api
from mupif import vertex
from mupif import cell
from mupif import transferoperator
from mupif import viewcontext
from mupif import agent
from mupif.api.api import *

from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors

daemon = Pyro4.Daemon()
ns     = Pyro4.locateNS()

def main():
    global mayavi

    mesh_a = mesh.UnstructuredMesh()
    # generate mesh_a and scalar vertex values
    vertices_a=[]
    values_a = []
    for i in range(20):
        for j in range (4):
            vertices_a.append(vertex.Vertex((i*4)+j,(i*4)+j+1, (float(i),float(j),0.0)))
            values_a.append((i,))
    cells_a = []
    for i in range(19):
        cells_a.append(cell.Quad_2d_lin(mesh_a, i*3+1, i*3+1, (i*4,   i*4+1, i*4+5,i*4+4)))
        cells_a.append(cell.Quad_2d_lin(mesh_a, i*3+2, i*3+2, (i*4+1, i*4+2, i*4+6,i*4+5)))
        cells_a.append(cell.Quad_2d_lin(mesh_a, i*3+3, i*3+3, (i*4+2, i*4+3, i*4+7,i*4+6)))

    mesh_a.setup(vertices_a, cells_a)
    field_a = field.Field(mesh_a, field.FieldID.FID_Temperature, field.FieldType.vertex_based, field.FieldValueType.scalar, values_a)
    
    src1 = util.field2VTKDataSource(field_a)

    mayavi.add_source(src1)
    mayavi.add_module(Outline())
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)

    #create a simple agent
    MyAgent = agent.Agent(daemon, ns, "example06.agent")
    tstep=timestep.TimeStep(1.,1.)
    # register field_a under key "1"
    MyAgent.registerField(field_a, 1, tstep)

    #Pyro4.Daemon.serveSimple(
    #        {
    #            MyAgent: "example.agent",
    #            field_a: "example.agent.field"
    #        },
    #        ns=True)

    daemon.requestLoop()
    



if __name__ == '__main__':

    try:
        mayavi
        mayavi.new_scene()
        main()
        
    except NameError:
        mayavi = Engine()
        mayavi.new_scene()
        main()
        #gui = GUI()
        #gui.start_event_loop()
