#!/usr/bin/env python

from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI

from mupif.api.sifel import mefelapi
from mupif import field
from mupif import mesh
from mupif import timestep
from mupif import util
from mupif import api
from mupif import vertex
from mupif import cell
from mupif import transferoperator

from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.core.dataset_manager import DatasetManager 
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors

from numpy import zeros

def main():
    global mayavi
    tstep = timestep.TimeStep(1.0, 1.0)
    problem = mefelapi.MEFEL_API("stena.in", "-kwd=3")
    mesh = problem.giveMesh(tstep)
    #src = util.mesh2VTKDataSource(mesh)
    # generate temperature vector
    temp=zeros((20,1))
    for i in range(20):
        temp[i][0]=10.0
    #print temp
    tempField = field.Field(mesh, field.FieldID.FID_Temperature, field.FieldType.vertex_based, field.FieldValueType.scalar, temp)
    problem.registerField(tempField, tstep)
    problem.solve(tstep)
    displacements = problem.giveField(field.FieldID.FID_Displacement, tstep)
    strains = problem.giveField(field.FieldID.FID_StrainTensor, tstep)
    stresses = problem.giveField(field.FieldID.FID_StressTensor, tstep)
    #print "huhu"
    #print displacements.asArray()

    ug = util.create_tvtk_ug(mesh)
    dsm=DatasetManager(dataset=ug) 
    dsm.add_array(strains.asArray(), 'strain', 'point') 
    dsm.add_array(stresses.asArray(), 'stress', 'point') 
    dsm.add_array(displacements.asArray(), 'displacements', 'point') 
    mayavi.add_source(VTKDataSource(data = ug))


    mayavi.add_module(Outline())
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)
     

if __name__ == '__main__':

    try:
        mayavi
        mayavi.new_scene()
        main()
        
    except NameError:
        mayavi = Engine()
        mayavi.new_scene()
        main()
        gui = GUI()
        gui.start_event_loop()
