#!/usr/bin/env python

from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI

from mupif import field
from mupif import mesh
from mupif import timestep
from mupif import util
from mupif import api
from mupif import vertex
from mupif import cell
from mupif import transferoperator
from mupif import viewcontext
from mupif import bbox

from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors


def main():
    global mayavi

    mesh_a = mesh.UnstructuredMesh()
    mesh_b = mesh.UnstructuredMesh()
    # generate mesh_a and scalar vertex values
    vertices_a=[]
    values_a = []
    for i in range(40):
        for j in range (15):
            vertices_a.append(vertex.Vertex((i*15)+j,(i*15)+j+1, (float(i),float(j),0.0)))
            values_a.append((i,))
    cells_a = []
    num=0
    for i in range(39):
        for j in range (14):
            cells_a.append(cell.Quad_2d_lin(mesh_a, num, num, ((i*15)+j, (i+1)*15+j, (i+1)*15+j+1, ((i*15)+j+1))))
            num=num+1

    mesh_a.setup(vertices_a, cells_a)
    field_a = field.Field(mesh_a, field.FieldID.FID_Temperature, field.FieldType.vertex_based, field.FieldValueType.scalar, values_a)


    #setup mesh view
    bb=bbox.BBox((0,0,0),(40,2.5,0))
    mesh_a_bboxed=mesh.UnstructuredMesh()
    viewcontext.BBoxViewContext(bb, mesh_a, mesh_a_bboxed)
    #offset mesh_a_bboxed z coordinate
    for i in mesh_a_bboxed.vertices():
        c = i.coords
        i.coords=(c[0], c[1], c[2]+1.0)
    print mesh_a_bboxed.mapping
    # and corresponding Field view
    fv=field.FieldView(mesh_a_bboxed, field_a, True)
    fv.update()

    src1 = util.field2VTKDataSource(field_a)
    mayavi.add_source(src1)
    mayavi.add_module(Outline())
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)

    #src2 = util.mesh2VTKDataSource(mesh_a_bboxed)
    src2 = util.field2VTKDataSource(fv)
    mayavi.add_source(src2)
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)
    

if __name__ == '__main__':

    try:
        mayavi
        mayavi.new_scene()
        main()
        
    except NameError:
        mayavi = Engine()
        mayavi.new_scene()
        main()
        gui = GUI()
        gui.start_event_loop()
