#!/usr/bin/env python

from mayavi.scripts import mayavi2
from tvtk.api import tvtk
from mayavi.core.engine import Engine
from pyface.api import GUI

from mupif import field
from mupif import mesh
from mupif import timestep
from mupif import util
from mupif import api
from mupif import vertex
from mupif import cell
from mupif import transferoperator

from mayavi.sources.vtk_data_source import VTKDataSource
from mayavi.modules.outline import Outline
from mayavi.modules.surface import Surface
from mayavi.modules.vectors import Vectors


def main():
    global mayavi

    mesh_a = mesh.UnstructuredMesh()
    mesh_b = mesh.UnstructuredMesh()
    # generate mesh_a and scalar vertex values
    vertices_a=[]
    values_a = []
    for i in range(4):
        for j in range (2):
            vertices_a.append(vertex.Vertex((i*2)+j,(i*2)+j+1, (float(i),float(j),0.0)))
            values_a.append((i,))
    cells_a = []
    for i in range(3):
        cells_a.append(cell.Quad_2d_lin(mesh_a, i+1, i+1, (i*2, i*2+2,i*2+3,i*2+1)))
    # generate mesh_b
    vertices_b=[]
    for i in range(6):
        for j in range (3):
            vertices_b.append(vertex.Vertex((i*3)+j,(i*3)+j+1, (i*3./5.,j*0.5,0)))
    cells_b = []
    for i in range(5):
        cells_b.append(cell.Quad_2d_lin(mesh_b, i*2+1, i*2+1, (i*3, i*3+3,i*3+4,i*3+1)))
        cells_b.append(cell.Quad_2d_lin(mesh_b, i*2+2, i*2+2, (i*3+1, i*3+4,i*3+5,i*3+2)))

    mesh_a.setup(vertices_a, cells_a)
    mesh_b.setup(vertices_b, cells_b)

    
    field_a = field.Field(mesh_a, field.FieldID.FID_Temperature, field.FieldType.vertex_based, field.FieldValueType.scalar, values_a)
    field_b = field.Field(mesh_b, field.FieldID.FID_Temperature, field.FieldType.vertex_based, field.FieldValueType.scalar, None)
    
    transferoperator.CellInterpolationTO().map(field_a, field_b)

    src1 = util.field2VTKDataSource(field_a)
    #src2 = util.mesh2VTKDataSource(mesh_b)
    src2 = util.field2VTKDataSource(field_b)

    mayavi.add_source(src1)
    mayavi.add_module(Outline())
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)

    mayavi.add_source(src2)
    mayavi.add_module(Outline())
    m = Surface()
    m.actor.property.representation='w'
    mayavi.add_module(m)
                  
if __name__ == '__main__':

    try:
        mayavi
        mayavi.new_scene()
        main()
        
    except NameError:
        mayavi = Engine()
        mayavi.new_scene()
        main()
        gui = GUI()
        gui.start_event_loop()
