#include <boost/python.hpp>
//#include <boost/python/return_internal_reference.hpp>
//#include <boost/python/manage_new_object.hpp>
//#include <boost/python/return_value_policy.hpp>
using namespace boost::python;
using namespace std;

#include "mupif.h"
#include "mechtop.h"
#include "vector.h"
#include "element.h"
//#include "galias.h"

//#include "gtopology.h"

extern mechtop *Mt;
//extern gtopology *Gtm;
void mefel_init (int argc, const char *argv[], stochdriver *stochd);
void mefel_init_2 (const char*p0, const char* p1, stochdriver *stochd) {
  const char *help[] = {p0, p1};
  mefel_init (2, help, stochd);
}
void mefel_init_3 (const char*p0, const char* p1, const char* p2, stochdriver *stochd) {
  const char *help[] = {p0, p1, p2};
  mefel_init (3, help, stochd);
}
void intpointval (double *gv,nonmechquant nmq,double scale);

int giveNumberOfNodes() {return Mt->nn;}
int giveNumberOfElements() {return Mt->ne;}

void giveElementConnectivity (int i, ivector& conn) {
  Mt->give_elemnodes(i, conn);
}

void  giveNodalCoord (long i, vector& c) {
  Mt->give_nodal_coord(i,c);
}

elemtype giveElemType (long i) {
  return Mt->give_elem_type(i);
}

void giveNodalDisplacement(long i, vector& c) {
  Mt->give_noddispl(i, c);
}
void giveNodalStrain(long i, vector& c) {
  Mt->give_nodal_strain(i, c);
}
void giveNodalStress(long i, vector& c) {
  Mt->give_nodal_stress(i, c);
}

void initIPValues(vector &v, nonmechquant nmq,double scale)
{
  intpointval(v.a, nmq, scale);
}
  
class PyVector : public vector, public wrapper<vector>
{
public:
  PyVector () : vector() {}
  PyVector (long i) : vector (i) {}
  long size () {return this->n;}
  void print () {
    int i;
    for (i=0; i<this->n; i++) 
      printf ("%le ", this->a[i]);
    printf("\n");
  }
};  


class PyIvector : public ivector, public wrapper<ivector>
{
public:
  PyIvector () : ivector () {}
  PyIvector (long i) : ivector (i) {}
  void print () {
    int i;
    for (i=0; i<this->n; i++) 
      printf ("%ld ", this->a[i]);
    printf("\n");
  }
};



BOOST_PYTHON_MODULE (mefel)
{

  class_<stochdriver, boost::noncopyable>("stochdriver", init<>())
	  ;
  class_<mt_glob_vec, boost::noncopyable>("mt_glob_vec", init<>())
	  ;
  class_<ivector, boost::noncopyable>("ivector", init<>())
	  ;

  class_<PyIvector, boost::noncopyable>("ivector")
    .def(init<>())
    .def(init<long>())
    .def("__getitem__", &PyIvector::__getItem__) 
    .def("__setitem__", &PyIvector::__setItem__)
    .def("p", &PyIvector::print)
    ;
  class_<PyVector, boost::noncopyable>("vector")
    .def(init<>())
    .def(init<long>())
    .def("__getitem__", &PyVector::__getItem__) 
    .def("__setitem__", &PyVector::__setItem__)
    .def("p", &PyVector::print)
    .def("size", &PyVector::size)
    ;

  def("mefel_init_2", mefel_init_2);
  def("mefel_init_3", mefel_init_3);
  def("visco_solver_init", visco_solver_init);
  def("one_step", one_step);
  def("print_close", print_close);
  def("giveNumberOfNodes", giveNumberOfNodes);
  def("giveNumberOfElements", giveNumberOfElements);
  def("giveElementConnectivity", giveElementConnectivity);
  def("give_nodal_coord", giveNodalCoord);
  def("give_elem_type", giveElemType);
  def("give_noddispl", giveNodalDisplacement);
  def("give_nodstrain", giveNodalStrain);
  def("give_nodstress", giveNodalStress);
  def("initIPValues", initIPValues);
  enum_<elemtype>("elemtype")
    .value("bar2d", bar2d)
    .value("planeelementlq", planeelementlq)
    .value("planeelementlt", planeelementlt)
    ;

  enum_<nonmechquant>("nonmechquant")
    .value("temperature", temperature)
    .value("moist", moist)
    .value("initial_temperature", initial_temperature)
    ;
  /*
  enum_<gelemtype>("gelemtype")
    .value("noelem", noelem)
    .value("linbar", linbar)
    .value("quadbar", quadbar)
    .value("lintriag", lintriag)
    .value("quadtriag", quadtriag)
    .value("linquad", linquad)
    .value("quadquad", quadquad)
    .value("lintetra", lintetra)
    .value("quadtetra", quadtetra)
    .value("linhexa", linhexa)
    ;
  */
  //def("make_foo", make_foo, return_value_policy<manage_new_object>())
    
}
