#
#               MuPIF: Multi-Physics Integration Framework 
#                   Copyright (C) 2010 Borek Patzak
#
#       Czech Technical University, Faculty of Civil Engineering,
#       Department of Mechanics, 166 29 Prague, Czech Republic
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import Pyro4
from mupif import field
from mupif import mesh
from mupif import timestep
from mupif import cell
from mupif import transferoperator
from mupif import viewcontext
from mupif.api.api import *


class AgentFieldRec:
    def __init__(self, field, uri=None):
        self.field = field
        self.uri   = uri


class Agent(API):
    def __init__(self, pyroDaemon, pyroNs, name, rank=None):
        self.fieldDict={}
        self.daemon = pyroDaemon
        self.ns = pyroNs
        self.name=name
        self.rank=rank # process rank; None for serial
        # register yourself at pyro name server
        nsName = "Mupif."+name
        if rank:
            nsName=nsName+"."+rank
        uri = self.daemon.register(self)
        self.ns.register(nsName, uri)
        print "NS: Agent registered as: \"", nsName, "\" uri:", uri

    def registerField(self, field, fieldID, tStep):
        self.fieldDict[fieldID]=AgentFieldRec(field)

    def giveField (self, fieldID, tStep):
        #Pyro4.Daemon.register(self.field)
        return self.fieldDict[fieldID].field

    def giveMesh (self, fieldID, tstep):
        return self.giveField(fieldID,tstep).giveMesh()

    def giveFieldUri (self, fieldID, tStep):
        if self.fieldDict[fieldID].uri:
            return self.fieldDict[fieldID].uri
        else:
            uri    = self.daemon.register(self.fieldDict[fieldID].field)
            self.ns.register("example.agent.field_"+str(fieldID), uri)
            self.fieldDict[fieldID].uri = uri
            return uri

    def giveBBoxFieldView (self, bbox, fieldID, tStep, unlinkMaster=True):
        afield = self.giveField(fieldID, tStep)
        mv = mesh.UnstructuredMesh()
        print "Constructing BBoxViewContext ....",
        vc = viewcontext.BBoxViewContext (bbox, afield.giveMesh(), mv)
        print "done"
        print "Constructing FieldView ....",
        fv = field.FieldView(mv, afield, True)
        print "done"
        if unlinkMaster:
            fv.master=None # to prevent master field to be transfered 
        #fv.update()
        return fv
